#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QNetworkAccessManager>
#include <QNetworkReply>

QT_BEGIN_NAMESPACE
namespace Ui {
class MainWindow;
}
QT_END_NAMESPACE

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = nullptr);
    ~MainWindow();

private slots:
    void onResultCryptoDetails(QNetworkReply *reply);
    void on_btnGetDetails_clicked();

private:
    Ui::MainWindow *ui;
    QNetworkAccessManager *managerGetCryptoDetails;
    void makeRequestGetCryptoDetails(int);
    QString apiKey;
    void setSliderValue(int);
    void setCryptoCombo();
    QByteArray responseCryptoDetails;
    void populateCryptoNames();
    void getDetailsOfCrypto();
    void showErrorMsg(QString &);

};
#endif // MAINWINDOW_H
