#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QJsonDocument>
#include <QNetworkReply>
#include <QJsonDocument>
#include <QJsonObject>
#include <QJsonArray>
#include <QJsonValue>
#include <QJsonParseError>
#include <QObject>
#include <QDebug>
#include <QUrl>
#include <QMessageBox>
#include <QUrlQuery>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->groupBox->setVisible(false);
    ui->comboxCryptoList->addItem("Please wait loading...");
    managerGetCryptoDetails = new QNetworkAccessManager(this);

    connect(managerGetCryptoDetails, &QNetworkAccessManager::finished, this, &MainWindow::onResultCryptoDetails);
    apiKey = "a53aa791-c63b-4333-8b63-af47d3f0177a";
    makeRequestGetCryptoDetails(0);

}

void MainWindow::setCryptoCombo()
{

}

MainWindow::~MainWindow()
{
    delete ui;
    delete managerGetCryptoDetails;
}

void MainWindow::makeRequestGetCryptoDetails(int limit) {
    qDebug() << "In makeRequestGetCryptoDetails()";
    // Set the API endpoint
    QUrl url("https://pro-api.coinmarketcap.com/v1/cryptocurrency/listings/latest");

    // Set request parameters
    QUrlQuery query;
    query.addQueryItem("start", "1");
    query.addQueryItem("limit", "5000");  // Adjust the limit as needed
    query.addQueryItem("convert", "USD");
    url.setQuery(query);


    // Create request object
    QNetworkRequest request;
    request.setUrl(QUrl(url));

    // Set headers (API key is passed here)
    request.setRawHeader("X-CMC_PRO_API_KEY", apiKey.toUtf8());  // Replace with your API key
    request.setRawHeader("Accept", "application/json");

    // Send GET request
    managerGetCryptoDetails->get(request);
}


void MainWindow::onResultCryptoDetails(QNetworkReply* reply) {
    qDebug() << "in onResultCryptoDetails()";
    if (reply->error() == QNetworkReply::NoError) {
        responseCryptoDetails = reply->readAll();
        // Parse JSON response
        QJsonDocument jsonResponse = QJsonDocument::fromJson(responseCryptoDetails);
        QJsonObject jsonObject = jsonResponse.object();
        QJsonArray dataArray = jsonObject["data"].toArray();
        QString jsonString = jsonResponse.toJson(QJsonDocument::Indented);
        //qDebug() << "jsonString : " << jsonString;
        //ui->textEdit->setText(jsonString);
        ui->comboxCryptoList->clear();
        qDebug() << "before populating combobox";
        populateCryptoNames();
        qDebug() << "after populating combobox";
        qDebug() << "Combo Elements : " << ui->comboxCryptoList->count();

    } else {
        // Error handling
        qDebug() << "Response Error:" << reply->errorString();
        qDebug() << reply->readAll();
        responseCryptoDetails = reply->readAll();
        QJsonDocument jsonResponse = QJsonDocument::fromJson(responseCryptoDetails);
        QJsonObject jsonObject = jsonResponse.object();
        QString errorMsg = jsonObject["status"].toObject()["error_message"].toString();
        showErrorMsg(errorMsg);

    }

    reply->deleteLater();
}

void MainWindow::on_btnGetDetails_clicked()
{
    getDetailsOfCrypto();
}

void MainWindow::populateCryptoNames()
{
    qDebug() << "in populateCryptoNames()";
    // get only crypto
    QJsonDocument jsonResponse = QJsonDocument::fromJson(responseCryptoDetails);
    QJsonObject jsonObject = jsonResponse.object();
    QJsonArray dataArray = jsonObject["data"].toArray();
    QString jsonString = jsonResponse.toJson(QJsonDocument::Indented);

    // Iterate over the array of cryptocurrencies
    for (const QJsonValue &value : dataArray) {
        QJsonObject cryptoObject = value.toObject();
        QString name = cryptoObject["name"].toString();
        //QString symbol = cryptoObject["symbol"].toString();
        //int rank = cryptoObject["rank"].toInt();
        ui->comboxCryptoList->addItem(name);
        //qDebug() << "Name:" << name << ", Symbol:" << symbol << ", Rank:" << rank;
    }
}

void MainWindow::getDetailsOfCrypto()
{
    bool gotDetails = false;
    // get only crypto
    QJsonDocument jsonResponse = QJsonDocument::fromJson(responseCryptoDetails);
    QJsonObject jsonObject = jsonResponse.object();
    QJsonArray dataArray = jsonObject["data"].toArray();
    QString jsonString = jsonResponse.toJson(QJsonDocument::Indented);

    //qDebug() << "jsonString : " <<jsonString;


    // Iterate over the array of cryptocurrencies
    for (const QJsonValue &value : dataArray) {
        QJsonObject cryptoObject = value.toObject();
        QString name = cryptoObject["name"].toString();
        if(name == ui->comboxCryptoList->currentText())
        {
            int isActive = cryptoObject["is_active"].toInt();
            QString slug = cryptoObject["symbol"].toString();
            QString symbol = cryptoObject["symbol"].toString();
            QString firstHistData = cryptoObject["date_added"].toString();
            QString lastHistData = cryptoObject["last_updated"].toString();
            int rank = cryptoObject["cmc_rank"].toInt();
            double price = cryptoObject["quote"].toObject()["USD"].toObject()["price"].toDouble();
            double change1hour = cryptoObject["quote"].toObject()["USD"].toObject()["percent_change_1h"].toDouble();
            double change24hour = cryptoObject["quote"].toObject()["USD"].toObject()["percent_change_24h"].toDouble();
            double change7day = cryptoObject["quote"].toObject()["USD"].toObject()["percent_change_7d"].toDouble();
            double change30day = cryptoObject["quote"].toObject()["USD"].toObject()["percent_change_30d"].toDouble();
            double change60day = cryptoObject["quote"].toObject()["USD"].toObject()["percent_change_60d"].toDouble();
            double change90day = cryptoObject["quote"].toObject()["USD"].toObject()["percent_change_90d"].toDouble();

           // qDebug() << "Name:" << name << ", Symbol:" << symbol << ", Rank:" << rank;
           // qDebug() << "isActive :" << isActive << ", slug"<<slug<<", firstHistData" << firstHistData;
            //qDebug() << " last_historical_data : " << lastHistData;
            ui->lblSymbol->setText(symbol);
            ui->lblFirstHData->setText(firstHistData);
            ui->lblLastHData->setText(lastHistData);
            ui->lblRank->setText(QString::number(rank));
            ui->lblValue->setText(QString::number(price) + " USD");
            ui->lblName->setText(name);

            ui->lbl1hour->setText(QString::number(change1hour));
            ui->lbl24hour->setText(QString::number(change24hour));
            ui->lbl7days->setText(QString::number(change7day));
            ui->lbl30days->setText(QString::number(change30day));
            ui->lbl60days->setText(QString::number(change60day));
            ui->lbl90days->setText(QString::number(change90day));
            gotDetails = true;
        break;
        }
    }

    if(gotDetails)
            ui->groupBox->setVisible(true);
}

void MainWindow::showErrorMsg(QString &msg)
{
QMessageBox  msgBox;
msgBox.setText("No Data Found! \n" + msg);
msgBox.setIcon(QMessageBox::Critical);
msgBox.exec();
}
