/*Copyright text*/

/**
 *  @file main.cpp
 *  @author: CppBuzz.com
 *  @date 10th Sep 2022
 *  @brief This is an entry file to a sample application which make use of Logger Frameowork. 
 *  
 */

#include <stdio.h>
#include <string.h>
#include <iostream>
#include <string>
#include <map>

#ifdef _WIN32
#include<Windows.h>
#else
#include<unistd.h>
#endif

#include "../LogFramework/inc/Logger.h"

using namespace std;

int main(int argc, char** argv)
{
	cout<<"### Launching application ###";
        Logger* pLogger = Logger::getLogHandler(Logger::FILE_STREAM, Logger::INFO);

	for(long int i = 0; i<100; i++) //run th loop 100 times
	{
        pLogger->writeLog(Logger::ERROR, "[_Agent::main] Unable to parse agruments. Service: %s, Usecase: %s, DebugLevel: %s", 
			  "Some Service Name", "Use Case ONe", "any message");
       
        pLogger->writeLog(Logger::ERROR, "[_Agent::main] Invalid Service Name. Service: %s", "Some Service Name");

        pLogger->writeLog(Logger::ERROR, "[_Agent::main] Invalid use case and/or its arguments. Service: %s, Usecase: %s", "ServiceName", "UseCase");

        pLogger->writeLog(Logger::DEBUG, "[_Agent::main] App Server execution started for the request: Service: %s, Usecase: %s", "ServiceName", "UseCase");

        pLogger->writeLog(Logger::ERROR, "[_Agent::main] Internal error in use case execution: Service: %s, Usecase: %s", "ServiceName", "UseCase");

        pLogger->writeLog(Logger::DEBUG, "[_Agent::main] App Server has successfully executed the request: Service: %s, Usecase: %s", "ServiceName", "UseCase");
	cout<<"\n##Sleeping for 2 seconds##";
        sleep(2); //sleep for 2 seconds 
	}
        cout<<"\n### Exiting application ###\n";
        return 0;
}
