#include<iostream>
#include<cstring>

#include "logextract.h"

using namespace std;

const string FilePath = "logcat";

void help();
int main(int argc, char** argv)
{
        if(argc < 2){
		help();
		return -1;
	}

	try
        {
		LogExtract  logextract(FilePath);

		
	        if(strcmp(argv[1], "-pid") == 0){
			logextract.filterbyProcessId(string(argv[2]));
		}
		else if(strcmp(argv[1], "-tid") == 0){
			logextract.filterbyThreadId(string(argv[2]));
		}
                else if(strcmp(argv[1], "-debuglevel") == 0){
			if(argc !=3){
				help();
				return -1;
                        }
                        logextract.filterbyLogLevel(string(argv[2]));
                }
                else if(strcmp(argv[1], "-date") == 0){
                        if(argc !=3){
                                help();
                                return -1;
                        }
                        logextract.filterbyDate(string(argv[2]));
                }
                else if(strcmp(argv[1], "-beginday") == 0){
                        if(argc !=5){
                                help();
                                return -1;
                        }
                        
			if(strcmp(argv[3], "-endday") != 0){
			        cout<<"\nError: -endday missing from arguments";	
				help(); 
				return -1;
			}

                        logextract.filterbyDateInterval(string(argv[2]), string(argv[4]));
		}
		else
		{
			cout<<"\n Invalid options..";
			help();
		}

		cout<<"\n\n ## end of the logs ##\n\n";
	}
	catch(string msg)
	{
		cout<<"\n Exception caught..";
		cout<<"\n Execption : "<<msg;
	}

	return 0;
}

void help()
{
	//2022:08:14 13:50:36:50 : 7019 : 140659458704320 : E :
	cout<<"\n ####### Usage ######";
	cout<<"\n ./extract_logs.out -debuglevel <I/D/W/E>";
	cout<<"\n ./extract_logs.out -pid <processid>";
	cout<<"\n ./gextract_logs.out -tid <threadid>";
	cout<<"\n ./extract_logs.out -date <YYYY:MM:DD>";
	cout<<"\n ./extract_logs.out -beginday <YYYY:MM:DD> -endday <YYY:MM:DD>\n\n";
}
