	/*Copyright text*/

#include "../inc/Logger.h"

	Logger::LogLevel Logger::m_eLogLevel = NONE;
	Logger::Stream Logger::m_eStream = NO_STREAM;
	const string Logger::LOGGER_LOG_LEVEL_STRING_NONE = "N";
	const string Logger::LOGGER_LOG_LEVEL_STRING_ERROR = "E";
	const string Logger::LOGGER_LOG_LEVEL_STRING_WARNING = "W";
	const string Logger::LOGGER_LOG_LEVEL_STRING_DEBUG = "D";
	const string Logger::LOGGER_LOG_LEVEL_STRING_INFO = "I";


	Logger::Logger(Stream stream, const string& fileName)
	{
	    if(stream == FILE_STREAM)
	    {
		 m_pLogWriter = new FileLogger(fileName);
	    }
	}

	Logger::~Logger()
	{
	    delete m_pLogWriter;

	}
	Logger* Logger::getLogHandler(Stream stream, LogLevel logLevel, const string& fileName)
	{
	    m_eLogLevel = logLevel;
	    static Logger onlyOneInstance(stream, fileName);
	    return &onlyOneInstance;
	}

	void Logger::writeLog(LogLevel logLevel, const char* format, ...)
	{
	    /*  Log only if current loglevel is less than default loglevel
		and loglevel & m_eLogLevel are not set to NONE
	    */
	    if((logLevel <= m_eLogLevel) && (logLevel && m_eLogLevel))
	    {   cout<<"\nIn Logger:writeLog()";
		char formattedString[2048];
		memset(formattedString, 0, 2048);

		va_list argPtr;
		va_start(argPtr, format);

		vsnprintf(formattedString, sizeof(formattedString), format, argPtr);

		va_end( argPtr );

		ostringstream temp;
		temp << getStringLogLevel(logLevel) << " : " << formattedString;

		m_pLogWriter->writeLog(temp.str());
	    }
	    else
	    {
		    cout<<"\nIn Logger:writeLog() not logging because of log level";
    }
}

string Logger::getStringLogLevel(LogLevel& logLevel)
{
    string sLevel;

    switch(logLevel)
    {
        case ERROR :
            sLevel = LOGGER_LOG_LEVEL_STRING_ERROR;
            break;
        case WARNING :
            sLevel = LOGGER_LOG_LEVEL_STRING_WARNING;
            break;
        case INFO :
            sLevel = LOGGER_LOG_LEVEL_STRING_INFO;
            break;
        case DEBUG:
            sLevel = LOGGER_LOG_LEVEL_STRING_DEBUG;
            break;
        case NONE:
            sLevel = LOGGER_LOG_LEVEL_STRING_NONE;
            break;
        default:
            sLevel = "";
    }

    return sLevel;
}

void Logger::setLogLevel(LogLevel logLevel)
{
    m_eLogLevel = logLevel;
}

bool Logger::setLogLevel(string logLevel)
{
    /* converting loglevel to upper case */
    transform(logLevel.begin(), logLevel.end(), logLevel.begin(), ::toupper);

    if(logLevel == LOGGER_LOG_LEVEL_STRING_NONE)
    {
        m_eLogLevel = NONE;
    }
    else if(logLevel == LOGGER_LOG_LEVEL_STRING_ERROR)
    {
        m_eLogLevel = ERROR;
    }
    else if(logLevel == LOGGER_LOG_LEVEL_STRING_WARNING)
    {
        m_eLogLevel = WARNING;
    }
    else if(logLevel == LOGGER_LOG_LEVEL_STRING_DEBUG)
    {
        m_eLogLevel = DEBUG;
    }
    else if(logLevel == LOGGER_LOG_LEVEL_STRING_INFO)
    {
        m_eLogLevel = INFO;
    }
    else
    {
        return false;
    }

    return true;
}

Logger::LogLevel Logger::getLogLevel()
{
    return m_eLogLevel;
}

