/* @file FileLogger.h
*
*  @brief Class representing MaxLogSize,FilePath, and WritLogs(
*
*  @author CppBuzz.com
*  @version 1.0
*/

#ifndef _FILELOGGER_H
#define _FILELOGGER_H

#include <string>
#include <sys/stat.h>
#include <cstdio>
#include <iostream>
#include <fstream>
#include <ctime>
#include <cstdlib>

#include "ILogWriter.h"

using namespace std;

class FileLogger : public ILogWriter
{
public:
  
    FileLogger(const string& fileName);

    /*  @brief function to send logs to streams
        @return -1 if any error occurs
        @return 0 if it is successful
    */
    int writeLog(const string& log);

private:

    /* m_nMaxLogSize is max size in bytes alloted for each log file */
    static const unsigned int m_nMaxLogSize;

    /* m_sLogsDirectory to keep directory of logfiles */
    static const string  m_sLogsDirectory;

    /* m_sFileName is keep name of file */
    static string m_sFileName;

    /*  @brief function to get current timestamp
        @return void
        @params char *
    */
    void getTimeStamp(char* ptr);

    /* @brief function to check and create log direcotry
       @return int
       @params void
    */
   int createLogDirectory();

};

#endif /* End of _FILELOGGER_H */
