#include "../inc/logextract.h"

#include <string>
#include <iostream>
#include <fstream>
#include <sstream>

using namespace std;


LogExtract::LogExtract(string FileName)
{
	if(FileName.length() == 0){
		cout<<"\n Error: FilePath is empty";
                throw "Invalid FilePath";
	}

	this->FileName = FileName;

}


int LogExtract::filterbyDateInterval(string BeginDate, string EndDate){
        if((BeginDate.length() == 0) || (EndDate.length() == 0))
        {
                cout<<"\nWarning: Dates can not be empty";
                return -1;
        }

        cout<<"\n\n ##### Checking logs with BeginDate: "<< BeginDate <<" & EndDate  : "<<EndDate<<" ####\n\n";

        ifstream InFile;
        InFile.open(FileName.c_str(), ios::in);

        if (!InFile.is_open())
        {
                throw("Unable to open file");
        }

        string line;
	int stopFlag = 0;
        while(getline(InFile, line))
        {
           string tmpLine = line;
           istringstream iss(tmpLine);
           string tmpString;
           int count = 0;

           while (getline(iss, tmpString, ' ') && (count++ != 0)) {
                //cout << "--" << tmpString<<endl;
           }

           string finalString;
           for(long unsigned int i=0; i<tmpString.length(); i++)
           {
                   if(tmpString[i] != ' ')
                   {
                           finalString.push_back(tmpString[i]);
                   }
           }


	   if(finalString.compare(BeginDate) > 0) 
            {	    
		    if(finalString.compare(EndDate) > 0)
	            {		    
		    cout<<"\n No logs found for this range of dates";
		    cout<<"\nNote: The oldest logs we have starts from "<<finalString;
		    return 0;
		    }
	 	    BeginDate = finalString;
            }

           if( (!finalString.compare(BeginDate)) ) {
                    cout<<"\n"<<line<<endl;

                     while(getline(InFile, line))
                     {
                     	        string tmpLine = line;
           			istringstream iss(tmpLine);
		           	string tmpString;
          			int count = 0;

           	      		while (getline(iss, tmpString, ' ') && (count++ != 0)) {
		                //cout << "--" << tmpString<<endl;
           			}

	        	   	string finalString;
        		        for(long unsigned int i=0; i<tmpString.length(); i++)
 		           	 {
                	         	if(tmpString[i] != ' ')
                          	 	{
                                 	finalString.push_back(tmpString[i]);
                          		}
           		         }

		           	//if( (!finalString.compare(BeginDate)) ) {
                    			cout<<"\n"<<line<<endl;
                     		//}
                                
				
                                if( (!finalString.compare(EndDate)) ) {
					//cout<<"\n"<<line<<endl;

			                while(getline(InFile, line))
                     			{
	                                	string tmpLine = line;
	        	                        istringstream iss(tmpLine);
	                	                string tmpString;
	                        	        int count = 0;

	                                	while (getline(iss, tmpString, ' ') && (count++ != 0)) {
		                                //cout << "--" << tmpString<<endl;
	        	                        }
	
                		                string finalString;
                        		        for(long unsigned int i=0; i<tmpString.length(); i++)
                                		 {
                                        		if(tmpString[i] != ' ')
                                        		{
	                                        	finalString.push_back(tmpString[i]);
        	                                	}
                	                 	}
	
        		                        if( (!finalString.compare(EndDate)) ) {
                	        	                cout<<"\n"<<line<<endl;
                		                }
						else
						{					
							stopFlag = 1;
							break;
						}
			                }//end of while loop

                                }

                     		if(stopFlag == 1)
		     		{       cout<<"\n breaking from outer loop as we have already printed till StartDate";
			     		break;
           	     		}

                   }
           }
         
         if(stopFlag == 1)
         {
	  	 cout<<"\n breaking from outer loop as we have already printed till StartDate";
                 break;
         }

        }
        return 0;
}


int LogExtract::filterbyDate(string Date){
        if(Date.length() == 0)
        {
                cout<<"\nWarning: Processor id can't be empty";
                return -1;
        }

        cout<<"\n\n ##### Checking logs with Date: "<< Date <<" Length : "<<Date.length()<<" ####";

        ifstream InFile;
        InFile.open(FileName.c_str(), ios::in);

        if (!InFile.is_open())
        {
                throw("Unable to open file");
        }

        string line;
        while(getline(InFile, line))
        {
           string tmpLine = line;
           istringstream iss(tmpLine);
           string tmpString;
           int count = 0;

           while (getline(iss, tmpString, ' ') && (count++ != 0)) {
                //cout << "--" << tmpString<<endl;
           }
         

           string finalString;
           for(long unsigned int i=0;i<tmpString.length(); i++)
           {
                   if(tmpString[i] != ' ')
                   {
                           finalString.push_back(tmpString[i]);
                   }
           }


           if(!finalString.compare(Date)){
                    cout<<"\n"<<line;
           }

        }
        return 0;
}

int LogExtract::filterbyLogLevel(string LogLevel){
        if(LogLevel.length() == 0)
        {
                cout<<"\nWarning: Processor id can't be empty";
                return -1;
        }

        cout<<"\n\n ##### Checking logs with LogLevel: "<< LogLevel <<" Length : "<<LogLevel.length()<<" ####\n\n";

        ifstream InFile;
        InFile.open(FileName.c_str(), ios::in);

        if (!InFile.is_open())
        {
                throw("Unable to open file");
        }

        string line;
        while(getline(InFile, line))
        {
           string tmpLine = line;
           istringstream iss(tmpLine);
           string tmpString;
           int count = 0;

           while (getline(iss, tmpString, ':') && (count++ != 8)) {
                //cout << "--" << tmpString<<endl;
           }

           string finalString;
           for(long unsigned int i=0;i<tmpString.length(); i++)
           {
                   if(tmpString[i] != ' ')
                   {
                           finalString.push_back(tmpString[i]);
                   }
           }

           if(!finalString.compare(LogLevel)){
                    cout<<"\n"<<line;
           }

        }
        return 0;
}

int LogExtract::filterbyProcessId(string Pid){
	if(Pid.length() == 0)
	{
		cout<<"\nWarning: Processor id can't be empty";
		return -1;
	}
      
        cout<<"\n\n ##### Checking logs with Pid : "<< Pid<<" Length : "<<Pid.length()<<" ####";

	ifstream InFile;
        InFile.open(FileName.c_str(), ios::in);

	if (!InFile.is_open())
        {
        	throw("Unable to open file");
        }

	string line;
        while(getline(InFile, line))
	{
           string tmpLine = line;
           istringstream iss(tmpLine);
           string tmpString; 
           int count = 0;

	   while (getline(iss, tmpString, ':') && (count++ != 6)) {
           	//cout << "--" << tmpString<<endl;
           }		 
           
	   string finalString;

	   for(long unsigned int i=0; i<tmpString.length(); i++)
	   {
		   if(tmpString[i] != ' ')
		   {
			   finalString.push_back(tmpString[i]);
		   }
	   }
	    
	   if(!finalString.compare(Pid)){
		    cout<<"\n"<<line;
	   }
	   
	}
	return 0;
}

int LogExtract::filterbyThreadId(string Tid){
        if(Tid.length() == 0)
        {
                cout<<"\nWarning: Thread id can't be empty";
                return -1;
        }

        cout<<"\n\n ##### Checking logs with Thread Id: "<< Tid<<" Length : "<<Tid.length()<<" ####\n\n";

        ifstream InFile;
        InFile.open(FileName.c_str(), ios::in);

        if (!InFile.is_open())
        {
                throw("Unable to open file");
        }

        string line;
        while(getline(InFile, line))
        {
           string tmpLine = line;
           istringstream iss(tmpLine);
           string tmpString;
           int count = 0;

           while (getline(iss, tmpString, ':') && (count++ != 7)) {
                //cout << "--" << tmpString<<endl;
           }

           string finalString;

           for(long unsigned int i=0; i<tmpString.length(); i++)
           {
                   if(tmpString[i] != ' ')
                   {
                           finalString.push_back(tmpString[i]);
                   }
           }

           if(!finalString.compare(Tid)){
                    cout<<"\n"<<line;
           }

        }


	return 0;
}

int LogExtract::filterbyTimeRange(string BeginTime, string EndTime){
        if((BeginTime.length() == 0) || (EndTime.length() == 0))
        {
                cout<<"\nWarning: Begin time or End time can not be empty";
                return -1;
        }

	return 0;
}


