/*Copyright text*/

#include <map>
#include <unistd.h>
#include <thread>

#include "../inc/FileLogger.h"

using namespace std;

string FileLogger::m_sFileName = "logcat";


FileLogger::FileLogger(const string& fileName)
{
    if(fileName != "")
    {
        m_sFileName = fileName;
    }

}

int FileLogger::writeLog(const string& log)
{
    /*  There can be max 5 log files example:
        Logger, Logger.0, Logger.1, Logger.2, Logger.3
    */

    cout<<"\nIn writeLog()";
    ofstream outFile;

    string tbuf = m_sFileName;

    outFile.open(tbuf.c_str(), ios::app);
    if (!outFile.is_open())
    {
        map<string, string> argList;
        argList.insert(pair<string, string>("File", tbuf));
        cout<<"\nError: Unable to create log file";
        return -1;
    }

    chmod(tbuf.c_str(), S_IRWXU|S_IRWXG|S_IRWXO);

    char buffer[80];
    getTimeStamp(buffer);

    std::thread::id thread_id = std::this_thread::get_id();

    /* Writing logs in log file */
    outFile << buffer << " : " << getpid() << " : " << thread_id << " : " << log << endl;
    outFile.close();

    return 0;
}

void FileLogger::getTimeStamp(char* ptr)
{
    time_t rawTime;
    tm* timeInfo;

    time(&rawTime);
    timeInfo = localtime(&rawTime);
    strftime(ptr, 80, "%Y:%m:%d %H:%M:%S:%M", timeInfo);
}

