/* @file ILogWriter.h
*
*  @brief An interface for all logger classes like FileLogger, StdOutLogger, StdErrLogger
*
*  @author CppBuzz.com
*  @version 1.0
*/

#ifndef I_LOGWRITER_H
#define I_LOGWRITER_H

#include <string>

using namespace std;

class ILogWriter
{
public:
    virtual ~ILogWriter(){}

    /*  @brief function to send log to logfile
        @return 0 if logging is successful
        @return -1 if logging is failed
        @param string
    */
    virtual int writeLog(const string& log) = 0;
};

#endif /* End of I_LOGWRITER_H */
